/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	CreateLineCenterToStart.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CApplication.h"
#include "CLine.h"

//	Creates a line using the center point of the given circle and
//	the start point of the given line and returns the line created
//	After creation the line is AutoConstrained.

HRESULT CreateLineCenterToStart(ILine *circle1, ILine *line1, ILine **newLine1)
{

	START_METHOD("CreateLineCenterToStart")

	HRESULT status = CONV_SUCCESS;

	// Get the center point of the circle
	IPoint *centerPoint1 = NULL;
	status = circle1->GetCenterPoint(&centerPoint1);
	CHECK_RETURN_STATUS(status)

	// Get the start point of the line
	IPoint *startPoint1 = NULL;
	status = line1->GetStartPoint(&startPoint1);
	CHECK_RETURN_STATUS(status)

	ILine *pLine1 = NULL;
	status = CreateLinePointToPoint(centerPoint1, startPoint1, &pLine1);
	CHECK_RETURN_STATUS(status)

	*newLine1 = pLine1;

	END_METHOD("CreateLineCenterToStart")
}
